class DM_SB extends TournamentScoreBoard;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

//Custom variables:
var float 	SBstart, Pstart, pXL, pYL, fXL, fYL, dXL, dYL, effXL, effYL;
var int		NotShown;
//Progress variables:
var string	Pname[32],
			Pprogress[32];	// Same-Up-Down
var int		Pvalue[32];

var RI myRI;

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetRI()
{
local RI aRI;

	ForEach AllActors(class'RI', aRI)
		{
		myRI = aRI;
		}
}

function HandleProgress(PlayerReplicationInfo PRI)
{
local int i;
local int value;

	for ( i=0;i<32;i++ )
		{
		if ( Pname[i] == "" )
			{
			Pname[i] = PRI.PlayerName;
			Pprogress[i] = "Same";
			i = 999;
			}
		else if ( Pname[i] == PRI.PlayerName )
			{
			value = int(PRI.Score) - int(PRI.Deaths);
			if ( Pvalue[i] < value )
				Pprogress[i] = "Up";
			else if ( Pvalue[i] > value )
				Pprogress[i] = "Down";
			Pvalue[i] = value;
			i = 999;
			}
		}
}

function PostBeginPlay()
{
local int i;

	for ( i=0;i<32;i++ )
		{
		Pname[i] = "";
		PProgress[i] = "Same";
		Pvalue[i] = 0;
		}

	SetRI();
		
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
local GameReplicationInfo GRI;
local float XL, YL;
local font CanvasFont;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 16;
	SBstart = 16 + 3*YL;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GRI.GameEndedComments, True);
		}
	else
		{
		Canvas.SetPos(0, ScoreStart);
		DrawVictoryConditions(Canvas);
		}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
local TournamentGameReplicationInfo TGRI;
local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if ( TGRI.FragLimit > 0 )
		{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
		}
	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
local float Ypos, XL, YL;
		
	Ypos = SBstart;
	
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("TEST", XL, YL);
	
	//Draw Category Frame:
	Canvas.SetPos( Canvas.ClipX * 0.5 - 400, Ypos);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 800, 1, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 400, Ypos + YL);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 800, 1, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 400, Ypos);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
	Canvas.SetPos( Canvas.ClipX * 0.5 + 399, Ypos);
	Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, YL, 0, 0, 4, 4);
	//Draw background
	Canvas.SetPos( Canvas.ClipX * 0.5 - 399, Ypos + 1);
	Canvas.DrawTile(Texture'DanesSetupTex.SB.CategoryBG', 798, YL - 1, 0, 0, 798, 32);
	
	Canvas.StrLen("Player:", pXL, pYL);
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 395, Ypos + 1);
	Canvas.DrawText("Player:");
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 396, Ypos);
	Canvas.DrawText("Player:");

	Canvas.StrLen("Frags:", fXL, fYL);
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(Canvas.ClipX * 0.5 - fXL + 1, Ypos + 1);
	Canvas.DrawText("Frags:");
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - fXL, Ypos);
	Canvas.DrawText("Frags:");

	Canvas.StrLen("Deaths:", dXL, dYL);
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 17, Ypos + 1);
	Canvas.DrawText("Deaths:");
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 16, Ypos);
	Canvas.DrawText("Deaths:");
	
	Canvas.StrLen("Eff:", effXL, effYL);
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(Canvas.ClipX * 0.5 + dXL + 33, Ypos + 1);
	Canvas.DrawText("Eff:");
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + dXL + 32, Ypos);
	Canvas.DrawText("Eff:");
	
	Pstart = Ypos + YL;	// Pstart is the Y coordinate used to define where to begin drawing player names and stats
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local float Adjust, eff, ping, pingScale;
local int i;

	HandleProgress(PRI);

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen("TEST", XL, YL);

	Adjust = (34 - YL) * 0.5;
	
	if ( Canvas.ClipY - YOffset > 35 )
		{
		//Draw Frame:
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos( Canvas.ClipX * 0.5 - 400, YOffset);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, 34, 0, 0, 4, 4);
		Canvas.SetPos( Canvas.ClipX * 0.5 + 399, YOffset);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 1, 34, 0, 0, 4, 4);
		Canvas.SetPos( Canvas.ClipX * 0.5 - 400, YOffset + 34);
		Canvas.DrawTile(Texture'DanesSetupTex.HUD.White', 800, 1, 0, 0, 4, 4);
		
		//Draw background:
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.SetPos( Canvas.ClipX * 0.5 - 399, YOffset + 1);
		Canvas.DrawTile(Texture'DanesSetupTex.SB.BlueGradient', 798, 32, 0, 0, 128, 128);
		
		//Draw TalkTexture
		if ( PRI.TalkTexture != none && Canvas.ClipX > 800)
			{
			Canvas.SetPos( Canvas.ClipX * 0.5 - 434, YOffset + 1);
			Canvas.DrawTile(PRI.TalkTexture, 32, 32, 0, 0, PRI.TalkTexture.USize, PRI.TalkTexture.VSize);
			}
		Canvas.Style = ERenderStyle.STY_Normal;
		
		//Draw Name:
		if ( PRI.bAdmin )
			{
			if ( myRI.bHiddenAdmin )
				{
				Canvas.DrawColor = GreenColor * 0.1;
				Canvas.SetPos(Canvas.ClipX * 0.5 - 394, YOffset + 1 + Adjust);
				Canvas.DrawText(PRI.PlayerName, False);
				Canvas.DrawColor = GreenColor;
				Canvas.SetPos(Canvas.ClipX * 0.5 - 395, YOffset + Adjust);
				Canvas.DrawText(PRI.PlayerName, False);
				}
			else
				{
				Canvas.DrawColor = WhiteColor * 0.1;
				Canvas.SetPos(Canvas.ClipX * 0.5 - 394, YOffset + 1 + Adjust);
				Canvas.DrawText(PRI.PlayerName$"(Admin)", False);
				Canvas.DrawColor = WhiteColor;
				Canvas.SetPos(Canvas.ClipX * 0.5 - 395, YOffset + Adjust);
				Canvas.DrawText(PRI.PlayerName$"(Admin)", False);
				}
			}
		else if ( bLocalPlayer )
			{
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 394, YOffset + 1 + Adjust);
			Canvas.DrawText(PRI.PlayerName, False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 395, YOffset + Adjust);
			Canvas.DrawText(PRI.PlayerName, False);
			}
		else
			{
			Canvas.DrawColor = GreenColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 394, YOffset + 1 + Adjust);
			Canvas.DrawText(PRI.PlayerName, False);
			Canvas.DrawColor = GreenColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 395, YOffset + Adjust);
			Canvas.DrawText(PRI.PlayerName, False);
			}
			
		//Draw Score:
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos( Canvas.ClipX * 0.5 - fXL + 1, YOffset + 1 + Adjust);
		Canvas.DrawText( int(PRI.Score), false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos( Canvas.ClipX * 0.5 - fXL, YOffset + Adjust);
		Canvas.DrawText( int(PRI.Score), false );
		
		//Draw Deaths:
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos( Canvas.ClipX * 0.5 + 17, YOffset + 1 + Adjust);
		Canvas.DrawText( int(PRI.Deaths), false );
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos( Canvas.ClipX * 0.5 + 16, YOffset + Adjust);
		Canvas.DrawText( int(PRI.Deaths), false );
		
		//Draw Eff:
		eff = PRI.Score / (PRI.Score + PRI.Deaths) * 100;
		if ( eff < 0 )
			eff = 0;
		else if ( PRI.Deaths < 0 )
			eff = 0;
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos( Canvas.ClipX * 0.5 + dXL + 33, YOffset + 1 + Adjust);
		Canvas.DrawText( int(eff)$"%", false );
		if ( eff == 100 )
			Canvas.DrawColor = WhiteColor;
		else if ( eff > 65 )
			Canvas.DrawColor = GreenColor;
		else if ( eff > 35 )
			Canvas.DrawColor = GoldColor;
		else
			Canvas.DrawColor = RedColor;
		Canvas.SetPos( Canvas.ClipX * 0.5 + dXL + 32, YOffset + Adjust);
		Canvas.DrawText( int(eff)$"%", false );
		
		//Draw Progress:
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos( Canvas.ClipX * 0.5 + 368, YOffset + 1);
		for ( i=0;i<32;i++ )
			{
			if ( Pname[i] == PRI.PlayerName )
				{
				if (Pprogress[i] == "Same")
					{
					Canvas.DrawTile(Texture'DanesSetupTex.SB.Progress_Same', 32, 32, 0, 0, 128, 128);
					i = 999;
					}
				else if (Pprogress[i] == "Up")
					{
					Canvas.DrawTile(Texture'DanesSetupTex.SB.Progress_Up', 32, 32, 0, 0, 128, 128);
					i = 999;
					}
				else if (Pprogress[i] == "Down")
					{
					Canvas.DrawTile(Texture'DanesSetupTex.SB.Progress_Down', 32, 32, 0, 0, 128, 128);
					i = 999;
					}
				}
			}
		
		//Draw Ping
		if ( !PRI.bIsAbot && Canvas.ClipX > 800)
			{
			if ( PRI.Ping > 350 )
				{
				ping = 350;
				}
			else
				ping = 350 - PRI.Ping;
			pingScale = 1 * (ping / 350);
			Canvas.DrawColor = WhiteColor * 0.9;
			Canvas.SetPos( Canvas.ClipX * 0.5 + 401, YOffset + 1);
			Canvas.DrawTile(Texture'DanesSetupTex.SB.PingBW', 64, 32, 0, 0, 256, 32);
			Canvas.SetPos( Canvas.ClipX * 0.5 + 401, YOffset + 1);
			Canvas.DrawTile(Texture'DanesSetupTex.SB.Ping', 64 * pingScale, 32, 0, 0, 256 * pingScale, 32);
			}
		}
	else
		{
		NotShown++;
		}

/*
	if ( (Canvas.ClipX > 512) && (Level.NetMode != NM_Standalone) )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset + 0.5 * YL );
		Canvas.DrawText( FPHString$": "@int(60 * PRI.Score/Time), false );

	}
*/
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = Canvas.CurY;
	YOffset = YStart;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);

	Canvas.SetPos(0, 0);
	NotShown = 0;
	
	YOffset = Pstart;
	
	for ( I=0; I<PlayerCount; I++ )
		{
		DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
		YOffset += 35;
		}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
	
	if ( NotShown > 0 )
		{
		Canvas.bCenter = True;
		Canvas.SetPos(0, Canvas.ClipY - YL);
		if ( NotShown == 1 )
			Canvas.DrawText( NotShown$" Player not shown", false );
		else
			Canvas.DrawText( NotShown$" Players not shown", false );
		Canvas.bCenter = False;
		}

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
}
